<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'albumall');
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('album', 'user');

// get special data templates from the datastore
$specialtemplates = array(
	'smiliecache',
	'bbcodecache'
);

// pre-cache templates
$globaltemplates = array(
	'memberinfo_usercss'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_album.php');
require_once(DIR . '/includes/functions_user.php');

// goto a specif page OR search for a word in the title OR album description
$vbulletin->input->clean_array_gpc('r', array(
	'page' => TYPE_UINT,
	'query' => TYPE_STR
));

$canviewalbums = (
	$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_albums']
		AND
	$permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canviewmembers']
		AND
	$permissions['albumpermissions'] & $vbulletin->bf_ugp_albumpermissions['canviewalbum']
);
$canviewgroups = (
	$vbulletin->options['socnet'] & $vbulletin->bf_misc_socnet['enable_groups']
		AND
	$vbulletin->userinfo['permissions']['socialgrouppermissions'] & $vbulletin->bf_ugp_socialgrouppermissions['canviewgroups']
);

if (!$canviewalbums)
{
	if (!$canviewgroups)
	{
		print_no_permission();
	}
}

$userinfo = verify_id('user', $vbulletin->userinfo['userid'], 1, 1, FETCH_USERINFO_USERCSS);

// don't show stuff for users awaiting moderation
if ($userinfo['usergroupid'] == 4 AND !($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
{
	print_no_permission();
}


cache_permissions($userinfo, false);
if (!can_moderate(0, 'caneditalbumpicture') AND !($userinfo['permissions']['albumpermissions'] & $vbulletin->bf_ugp_albumpermissions['canalbum']))
{
	print_no_permission();
}

if (!can_view_profile_section($userinfo['userid'], 'albums'))
{
	// private album that we can not see
	standard_error(fetch_error('invalidid', $vbphrase['album'], $vbulletin->options['contactuslink']));
}


// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

	$state=array('public');
	// mods, admins &  super mods can all see album cover pics (they may NOT be able to view the actual album!)
	if ($userinfo['usergroupid']==5 OR $userinfo['usergroupid']==6 OR $userinfo['usergroupid']==7)
	{
		$state[]='private';
		$state[]='profile';
	}

	$searchquery = $vbulletin->GPC['query'];
	if ($searchquery)
	{
		$searchwhere = "AND (album.title LIKE '%" . $db->escape_string($searchquery) . "%' 
						OR album.description LIKE '%" . $db->escape_string($searchquery) . "%'
						OR user.username LIKE '%"  . $db->escape_string($searchquery) . "%')";
		$searchquery = htmlspecialchars($searchquery);
	}
	
// get album count first
	$albumcount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM 
			" . TABLE_PREFIX . "album as album
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (album.userid = user.userid)
		WHERE 
			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
			OR (state IN ('" . implode("', '", $state) . "') AND album.visible > 0))
			$searchwhere
	");
	
	if ($vbulletin->GPC['page'] < 1)
	{
		$vbulletin->GPC['page'] = 1;
	}

	$perpage = $vbulletin->options['albums_perpage'];
	$total_pages = max(ceil($albumcount['total'] / $perpage), 1); // handle the case of 0 albums
	$page = ($vbulletin->GPC['page'] > $total_pages ? $total_pages : $vbulletin->GPC['page']);
	$start = ($page - 1) * $perpage;

	// fetch data and prepare data
	$albums = $db->query_read("
		SELECT album.*,
			attachment.attachmentid,
			IF(filedata.thumbnail_filesize > 0, 1, 0) AS hasthumbnail, filedata.thumbnail_dateline, filedata.thumbnail_width, filedata.thumbnail_height
		FROM " . TABLE_PREFIX . "album AS album
			LEFT JOIN " . TABLE_PREFIX . "attachment AS attachment ON (album.coverattachmentid = attachment.attachmentid)
			LEFT JOIN " . TABLE_PREFIX . "filedata AS filedata ON (attachment.filedataid = filedata.filedataid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (attachment.userid = user.userid)
		WHERE
			(album.userid ='" . $vbulletin->userinfo['userid'] . "'
			OR (album.state IN ('" . implode("', '", $state) . "') AND album.visible > 0))
			$searchwhere
		ORDER BY album.lastpicturedate DESC
		LIMIT $start, $perpage
	");

	$albumbits = '';
	while ($album = $db->fetch_array($albums))
	{
		$album['picturecount'] = vb_number_format($album['visible']);
		$album['picturedate'] = vbdate($vbulletin->options['dateformat'], $album['lastpicturedate'], true);
		$album['picturetime'] = vbdate($vbulletin->options['timeformat'], $album['lastpicturedate']);

		$album['description_html'] = get_first_line($album['description']);
//		nl2br(fetch_word_wrapped_string(fetch_censored_text($album['description'])));
		$album['title_html'] = get_first_line($album['title']);
//		$album['title_html'] = fetch_word_wrapped_string(fetch_censored_text($album['title']));
		$album['coverdimensions'] = ($album['thumbnail_width'] ? "width=\"$album[thumbnail_width]\" height=\"$album[thumbnail_height]\"" : '');

		if ($album['state'] == 'private')
		{
			$show['personalalbum'] = true;
			$albumtype = $vbphrase['private_album_paren'];
		}
		else if ($album['state'] == 'profile')
		{
			$show['personalalbum'] = true;
			$albumtype = $vbphrase['profile_album_paren'];
		}
		else
		{
			$show['personalalbum'] = false;
		}

		if ($album['moderation'] AND (can_moderate(0, 'canmoderatepictures') OR $vbulletin->userinfo['userid'] == $album['userid']))
		{
			$show['moderated'] = true;
			$album['moderatedcount'] = vb_number_format($album['moderation']);
		}
		else
		{
			$show['moderated'] = false;
		}

		$templater = vB_Template::create('albumbit');
			$templater->register('album', $album);
			$templater->register('albumtype', $albumtype);
			$albumbits .= $templater->render();
	}

	$pagenav = construct_page_nav($page, $perpage, $albumcount['total'],
		'albumall.php?' . $vbulletin->session->vars['sessionurl_q'] . "query=$searchquery" . ''
	);

	// navbar and final output
	$navbits = construct_navbits(array(
		'albumall.php' . $vbulletin->session->vars['sessionurl_q'] . "query=$searchquery"  => 'Gallery' 
		));

	$navbar = render_navbar_template($navbits);

	$custompagetitle = 'Album Gallery';

	$templater = vB_Template::create('gallery_albumall');
		$templater->register_page_templates();
		$templater->register('albumbits', $albumbits);
		$templater->register('returnscript', 'albumall.php');
		$templater->register('custompagetitle', $custompagetitle);
		$templater->register('navbar', $navbar);
		$templater->register('pagenav', $pagenav);
	print_output($templater->render());

function get_first_line($string) // retuns first line from string in HTML
{
		if (strlen($string)>25)
		{
			$string = wordwrap(fetch_censored_text($string),25);
			return 	nl2br(substr($string, 0, strpos($string, "\n"))) . ' ...';
		}
		return $string;
}
?>
